<?php
/* --------------------------------------------------------------
   SeoTagsDataProviderDecorator.php 2025-09-11
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2022 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/
declare(strict_types=1);

namespace Gambio\Admin\Modules\SeoTags\Decorator;

require_once dirname(__DIR__, 4) . "/GXMainComponents/Shared/SeoTagsDataProvider.inc.php";

use Gambio\Admin\Modules\SeoTags\Interfaces\SeoTagsDataProviderDecoratorInterface;
use \SeoTagsDataProvider;


abstract class SeoTagsDataProviderDecorator implements SeoTagsDataProviderDecoratorInterface
{
    /**
     * @return array
     */
    public function getExcludeGetParams(): array
    {
        return SeoTagsDataProvider::getExcludeGetParams();
    }
    
    
    /**
     * @return array
     */
    public function getNoIndexKeys(): array
    {
        return SeoTagsDataProvider::getNoIndexKeys();
    }
    
    
    /**
     * @return array
     */
    public function getNoIndexKeysPerPageType(): array
    {
        return SeoTagsDataProvider::getNoIndexKeysPerPageType();
    }
    
    
    /**
     * @return array
     */
    public function getNoFollowKeysPerPageType(): array
    {
        return SeoTagsDataProvider::getNoFollowKeysPerPageType();
    }
    
    
    /**
     * @return array
     */
    public function getNoRelPrevNext(): array
    {
        return SeoTagsDataProvider::getNoRelPrevNext();
    }
    
    
    /**
     * @return array
     */
    public function getNoCanonicalFiles(): array
    {
        return SeoTagsDataProvider::getNoCanonicalFiles();
    }
    
    
    /**
     * @return array
     */
    public function getNoIndexFiles(): array
    {
        return SeoTagsDataProvider::getExcludeKeysFromCanonical();
    }
    
    
    /**
     * @return array
     */
    public function getExcludeKeysFromCanonical(): array
    {
        return SeoTagsDataProvider::getExcludeKeysFromCanonical();
    }
    
    
    /**
     * @return array
     */
    public function getExcludeKeysFromCanonicalPerPageType(): array
    {
        return SeoTagsDataProvider::getExcludeKeysFromCanonicalPerPageType();
    }
    
    
}